/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.item;

import compasses.expandedstorage.impl.item.EntityInteractableItem;
import compasses.expandedstorage.impl.item.ToolUsageResult;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.BlockConversionRecipe;
import compasses.expandedstorage.impl.recipe.ConversionRecipeManager;
import compasses.expandedstorage.impl.recipe.EntityConversionRecipe;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StorageConversionKit
extends Item
implements EntityInteractableItem {
    public static final ToolUsageResult NOT_ENOUGH_UPGRADES = ToolUsageResult.fail();
    private final Component instructionsFirst;
    private final Component instructionsSecond;

    public StorageConversionKit(Item.Properties settings, ResourceLocation fromTier, ResourceLocation toTier, boolean manuallyWrapTooltips) {
        super(settings);
        if (manuallyWrapTooltips) {
            this.instructionsFirst = Component.m_237110_((String)("tooltip.expandedstorage.conversion_kit_" + fromTier.m_135815_() + "_" + toTier.m_135815_() + "_1"), (Object[])new Object[]{Utils.ALT_USE}).m_130940_(ChatFormatting.GRAY);
            this.instructionsSecond = Component.m_237110_((String)("tooltip.expandedstorage.conversion_kit_" + fromTier.m_135815_() + "_" + toTier.m_135815_() + "_2"), (Object[])new Object[]{Utils.ALT_USE}).m_130940_(ChatFormatting.GRAY);
        } else {
            this.instructionsFirst = Component.m_237110_((String)("tooltip.expandedstorage.conversion_kit_" + fromTier.m_135815_() + "_" + toTier.m_135815_() + "_1"), (Object[])new Object[]{Utils.ALT_USE}).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)("tooltip.expandedstorage.conversion_kit_" + fromTier.m_135815_() + "_" + toTier.m_135815_() + "_2"), (Object[])new Object[]{Utils.ALT_USE}).m_130940_(ChatFormatting.GRAY));
            this.instructionsSecond = Component.m_237113_((String)"");
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            ItemStack tool = context.m_43722_();
            BlockPos pos = context.m_8083_();
            BlockState state = level.m_8055_(pos);
            BlockConversionRecipe<?> recipe = ConversionRecipeManager.INSTANCE.getBlockRecipe(state, tool);
            if (recipe != null) {
                if (level.m_5776_()) {
                    return InteractionResult.CONSUME;
                }
                ToolUsageResult result = recipe.process(level, player, tool, state, pos);
                if (result == NOT_ENOUGH_UPGRADES) {
                    player.m_5661_((Component)Component.m_237110_((String)"tooltip.expandedstorage.conversion_kit.need_x_upgrades", (Object[])new Object[]{1}), true);
                } else if (result.getResult().m_19080_()) {
                    player.m_36335_().m_41524_((Item)this, 20);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag context) {
        list.add(this.instructionsFirst);
        if (!this.instructionsSecond.getString().equals("")) {
            list.add(this.instructionsSecond);
        }
    }

    @Override
    public InteractionResult es_interactEntity(Level level, Entity entity, Player player, InteractionHand hand, ItemStack stack) {
        EntityConversionRecipe<?> recipe = ConversionRecipeManager.INSTANCE.getEntityRecipe(entity, stack);
        if (recipe != null && recipe.process(level, player, stack, entity).m_19080_()) {
            player.m_36335_().m_41524_((Item)this, 20);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

